<?php if (!defined('ABSPATH')) die('Direct access forbidden.');
/**
 * helper functions
 */

// simply echo the variable
// ----------------------------------------------------------------------------------------
function qoxag_return( $s ) {

	return qoxag_kses($s);
}

// return the specific value from theme options/ customizer/ etc
// ----------------------------------------------------------------------------------------
function qoxag_option( $key, $default_value = '', $method = 'customizer' ) {
	if ( defined( 'DEVM' ) ) {
		switch ( $method ) {
			case 'customizer':
				$value = devm_theme_option( $key );
				break;
			default:
				$value = '';
				break;
		}
		return (!isset($value) || $value == '') ? $default_value :  $value;
	}
	return $default_value;
}


// return the specific value from metabox
// ----------------------------------------------------------------------------------------
function qoxag_meta_option( $postid, $key, $default_value = '' ) {
	if ( defined( 'DEVM' ) ) {
		$value = devm_meta_option($postid, $key, $default_value);
	}
	return (!isset($value) || $value == '') ? $default_value :  $value;
}

// extract unyson image data from option value in a much simple way
// ----------------------------------------------------------------------------------------
function qoxag_src( $key, $default_value = '', $input_as_attachment = false ) { // for src
	if ( $input_as_attachment == true ) {
		$attachment = $key;
	} else {
		$attachment = qoxag_option( $key );
	}

	if ( isset( $attachment[ 'url' ] ) && !empty( $attachment ) ) {
		return $attachment[ 'url' ];
	}

	return $default_value;
}


// WP kses allowed tags
// ----------------------------------------------------------------------------------------
function qoxag_kses( $raw ) {

	$allowed_tags = array(
		'a'								 => array(
			'class'	 => array(),
			'href'	 => array(),
			'rel'	 => array(),
			'title'	 => array(),
		),
		'abbr'							 => array(
			'title' => array(),
		),
		'b'								 => array(),
		'blockquote'					 => array(
			'cite' => array(),
		),
		'cite'							 => array(
			'title' => array(),
		),
		'code'							 => array(),
		'del'							 => array(
			'datetime'	 => array(),
			'title'		 => array(),
		),
		'dd'							 => array(),
		'div'							 => array(
			'class'	 => array(),
			'title'	 => array(),
			'style'	 => array(),
		),
		'dl'							 => array(),
		'dt'							 => array(),
		'em'							 => array(),
		'h1'							 => array(),
		'h2'							 => array(),
		'h3'							 => array(),
		'h4'							 => array(),
		'h5'							 => array(),
		'h6'							 => array(),
		'i'								 => array(
			'class' => array(),
		),
		'img'							 => array(
			'alt'	 => array(),
			'class'	 => array(),
			'height' => array(),
			'src'	 => array(),
			'width'	 => array(),
		),
		'li'							 => array(
			'class' => array(),
		),
		'ol'							 => array(
			'class' => array(),
		),
		'p'								 => array(
			'class' => array(),
		),
		'q'								 => array(
			'cite'	 => array(),
			'title'	 => array(),
		),
		'span'							 => array(
			'class'	 => array(),
			'title'	 => array(),
			'style'	 => array(),
		),
		'iframe'						 => array(
			'width'			 => array(),
			'height'		 => array(),
			'scrolling'		 => array(),
			'frameborder'	 => array(),
			'allow'			 => array(),
			'src'			 => array(),
		),
		'strike'						 => array(),
		'br'							 => array(),
		'strong'						 => array(),
		'ul'							 => array(
			'class' => array(),
		),
	);

	if ( function_exists( 'wp_kses' ) ) { // WP is here
		$allowed = wp_kses( $raw, $allowed_tags );
	} else {
		$allowed = $raw;
	}


	return $allowed;
}


// build google font url
// ----------------------------------------------------------------------------------------
function qoxag_google_fonts_url($font_families	 = []) {
	$fonts_url		 = '';
	/*
    Translators: If there are characters in your language that are not supported
    by chosen font(s), translate this to 'off'. Do not translate into your own language.
    */
	if ( $font_families && 'off' !== _x( 'on', 'Google font: on or off', 'qoxag' ) ) {
		$query_args = array(
			'family' => implode( '&family=', $font_families )
		);

		$fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css2' );
	}

	return esc_url_raw( $fonts_url );
}

// return cover image from an youtube video url
// ----------------------------------------------------------------------------------------
function qoxag_youtube_cover( $e ) {
	$src = null;
	//get the url
	if ( $e != '' ){
		$url = $e;
		$queryString = parse_url( $url, PHP_URL_QUERY );
		parse_str( $queryString, $params );
		$v = $params[ 'v' ];
		//generate the src
		if ( strlen( $v ) > 0 ) {
			$src = "http://i3.ytimg.com/vi/$v/default.jpg";
		}
	}

	return $src;
}


// return embed code for sound cloud
// ----------------------------------------------------------------------------------------
function qoxag_soundcloud_embed( $url ) {
	return 'https://w.soundcloud.com/player/?url=' . urlencode($url) . '&auto_play=false&color=915f33&theme_color=00FF00';
}


// return embed code video url
// ----------------------------------------------------------------------------------------
function qoxag_video_embed($url){
    //This is a general function for generating an embed link of an FB/Vimeo/Youtube Video.
	$embed_url = '';
    if(strpos($url, 'facebook.com/') !== false) {
        //it is FB video
        $embed_url ='https://www.facebook.com/plugins/video.php?href='.rawurlencode($url).'&show_text=1&width=200';
    }else if(strpos($url, 'vimeo.com/') !== false) {
        //it is Vimeo video
        $video_id = explode("vimeo.com/",$url)[1];
        if(strpos($video_id, '&') !== false){
            $video_id = explode("&",$video_id)[0];
        }
        $embed_url ='https://player.vimeo.com/video/'.$video_id;
    }else if(strpos($url, 'youtube.com/') !== false) {
        //it is Youtube video
        $video_id = explode("v=",$url)[1];
        if(strpos($video_id, '&') !== false){
            $video_id = explode("&",$video_id)[0];
        }
		$embed_url ='https://www.youtube.com/embed/'.$video_id;
    }else if(strpos($url, 'youtu.be/') !== false){
        //it is Youtube video
        $video_id = explode("youtu.be/",$url)[1];
        if(strpos($video_id, '&') !== false){
            $video_id = explode("&",$video_id)[0];
        }
        $embed_url ='https://www.youtube.com/embed/'.$video_id;
    }else{
        //for new valid video URL
		$embed_url = $url;
    }
    return $embed_url;
}

if ( !function_exists( 'qoxag_advanced_font_styles' ) ) :

	/**
	 * Get shortcode advanced Font styles
	 *
	 */
	function qoxag_advanced_font_styles( $data ) {

		$style = [];

		if (is_string($data)) {
			$style = json_decode($data, true);
		} else {
			$style = $data;
		}

		$font_styles = $font_weight = '';

		$font_weight = (isset( $style[ 'weight' ] ) && $style[ 'weight' ]) ? 'font-weight:' . esc_attr( $style[ 'weight' ] ) . ';' : '';

		$font_styles .= isset( $style[ 'family' ] ) ? 'font-family: ' . $style[ 'family' ] . ', sans-serif;' : '';
		$font_styles .= isset($style[ 'style' ] ) && $style[ 'style' ] ? 'font-style:' . esc_attr( $style[ 'style' ] ) . ';' : '';

		$font_styles .= isset( $style[ 'color' ] ) && !empty( $style[ 'color' ] ) ? 'color:' . esc_attr( $style[ 'color' ] ) . ';' : '';
		$font_styles .= isset( $style[ 'line_height' ] ) && !empty( $style[ 'line_height' ] ) ? 'line-height:' . esc_attr( $style[ 'line_height' ] / $style[ 'size' ]) . ';' : '';
		$font_styles .= isset( $style[ 'letter_spacing' ] ) && !empty( $style[ 'letter_spacing' ] ) ? 'letter-spacing:' . esc_attr( $style[ 'letter_spacing' ] / 1000 * 1 ) . 'rem;' : '';
		$font_styles .= isset( $style[ 'size' ] ) && !empty( $style[ 'size' ] ) ? 'font-size:' . esc_attr( $style[ 'size' ] ) . 'px;' : '';

		$font_styles .= !empty( $font_weight ) ? $font_weight : '';

		return !empty( $font_styles ) ? $font_styles : '';
	}

endif;


/**
 * hooks for wp blog part
 */

// if there is no excerpt, sets a defult placeholder
// ----------------------------------------------------------------------------------------
function qoxag_excerpt( $words = 20 ) {
	$excerpt		 = get_the_excerpt();
	$trimmed_content = wp_trim_words( $excerpt, $words );
	echo qoxag_kses( $trimmed_content );
}


// change textarea position in comment form
// ----------------------------------------------------------------------------------------
function qoxag_move_comment_textarea_to_bottom( $fields ) {
	$comment_field		 = $fields[ 'comment' ];
	unset( $fields[ 'comment' ] );
	$fields[ 'comment' ] = $comment_field;
	return $fields;
}
add_filter( 'comment_form_fields', 'qoxag_move_comment_textarea_to_bottom' );


// change textarea position in comment form
// ----------------------------------------------------------------------------------------
function qoxag_search_form( $form ) {
    $form = '
        <form  method="get" action="' . esc_url( home_url( '/' ) ) . '" class="qoxag-serach xs-search-group">
            <div class="input-group">
                <input type="search" class="form-control" name="s" placeholder="' .esc_attr__( 'Search', 'qoxag' ) . '" value="' . get_search_query() . '">
                <div class="input-group-append">
                    <button class="input-group-text search-button"><i class="xts-icon xts-search"></i></button>
                </div>
            </div>
        </form>';
	return $form;
}
add_filter( 'get_search_form', 'qoxag_search_form' );

function qoxag_body_classes( $classes ) {

    if ( is_active_sidebar( 'sidebar-1' ) ) {
        $classes[] = 'sidebar-active';
    }else{
        $classes[] = 'sidebar-inactive';
    }
    $box_class =  qoxag_option('body_box_layout');
	//$box_class = qoxag_meta_option( get_the_ID(), 'page_body_box_layout' );
    if($box_class == 'yes'){
		$classes[] = 'body-box-layout';
    }

    return $classes;
 }

 add_filter( 'body_class','qoxag_body_classes' );


function get_widget_template($temp_name) {
	return QOXAG_CORE . '/elementor/templates/' . $temp_name . '/' . $temp_name . '.php';
}

function qoxag_cat_style( $termid,$key,$css='color') {    
	$style = '';
	$prefix    = 'devmonsta_';
	$key = $prefix . $key;
	if ( defined( 'DEVM' ) ) {
	   $value = devm_taxonomy($termid, $key, true);
	   if($value != ''){
		  if($css == 'color'){
			 $style = 'color:'.$value.';';
		  }else{
			 $style = 'background-color:' . $value.';';           
		  }
	   }       
	}
	return $style; 
 }

// function to display number of posts.
function qoxag_get_postview($postid){
$count_key = 'qoxag_post_views_count';
$count = get_post_meta($postid, $count_key, true);
if($count==''){
return "0";
}
return esc_html($count);
}

function qoxag_all_taxonomy($taxonomy){
	if(!taxonomy_exists($taxonomy)){
		return [];
	}
	$tax_terms = get_terms($taxonomy, array('hide_empty' => false));
	$category_list = [];
	if(!empty($tax_terms)){
		foreach($tax_terms as $term_single) {      
			$category_list[$term_single->slug] = [$term_single->name];
		}
	}
	
	return $category_list;
}
 
 // function to count views.
 function qoxag_set_postview($postid) {
	$count_key = 'qoxag_post_views_count';
	$count = get_post_meta($postid, $count_key, true);
	if($count==''){
		$count = 0;
		delete_post_meta($postid, $count_key);
		add_post_meta($postid, $count_key, '0');
	}else{
		$count++;
		update_post_meta($postid, $count_key, $count);
	}
 }

 function qoxag_track_post_views($post_id) {	
		if ( !is_single() ) return;
		if ( empty ( $post_id) ) {
			global $post;
			$post_id = $post->ID;    
		}
		qoxag_set_postview($post_id);
}

add_action( 'wp_head', 'qoxag_track_post_views');

if (!function_exists('qoxag_content_estimated_reading_time')) {
	function qoxag_content_estimated_reading_time($content = '', $wpm = 200) {
	   $clean_content = esc_html($content);
	   $word_count = str_word_count($clean_content);
	   $time = ceil($word_count / $wpm);
	   if ($time <= 1) {
		  $time .= esc_html__(' min read', 'qoxag');
	   } else {
		  $time .= esc_html__(' min read', 'qoxag');
	   }
	   $output = '<span class="post-read-time">';
	   $output .= '<i class="xts-icon xts-eye"></i>';
	   $output .= '<span class="read-time"> ' . $time . '</span>' . ' ';
	   $output .= '</span>';
	   return $output;
	}
 }

//category layout
function qoxag_cat_layout($termid,$default='style1') {    
	$cat_layout = $default;
	$prefix    = 'devmonsta_';
	if ( defined( 'DEVM' ) ) {
	   $overwrite = devm_taxonomy($termid, $prefix.'category_layout_overwrite', true);
	   if($overwrite == 'yes'){
		  $cat_layout = devm_taxonomy($termid, $prefix.'qoxag_single_category_layout', true);
	   } else{
		  $cat_layout = qoxag_option('qoxag_blog_category_layout','style2');
	   }       
	}
	return $cat_layout; 
 }

 //amp fonts
add_action( 'amp_post_template_head', 'qoxag_amp_fonts', 1 );
function qoxag_amp_fonts(){
	$font_families   = array();
	$font_families[] = 'Inter:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i';
	$font_families[] = 'Zilla Slab:300,300i,400,400i,500,500i,700,700i,900,900i';
	$font_families   = apply_filters( 'qoxag_amp_fonts', $font_families );

	$params          = array(
	'family' => urlencode( implode( '|', $font_families ) ),
	'subset' => urlencode( 'latin,latin-ext' ),
	);
	$fonts_url       = add_query_arg( $params, 'https://fonts.googleapis.com/css' );
	$fonts_url = add_query_arg(array('display'=>'swap'), $fonts_url);
	?>
	<link rel="stylesheet" href="<?php echo esc_url( $fonts_url ); ?>">
	<link rel="stylesheet" href="<?php echo esc_url( QOXAG_CSS . '/public/icon.css' ); ?>">
	<link rel="stylesheet" href="<?php echo esc_url( plugins_url() . '/elementor/assets/css/frontend.min.css' ); ?>">
	<?php
	  
}

/** dark light mode **/
if( ! function_exists( 'qoxag_html_class' ) ) {

	add_filter( 'language_attributes', 'qoxag_html_class' );
	function qoxag_html_class( $output ){

		$classes = array(); 

		// Enable Theme Dark Skin
		if( qoxag_option('style_theme_setting') == 'yes' ){
			$classes[] = 'dark-mode';
			$data_skin = 'dark';
		}
		else{
			$data_skin = 'light';
		}

		$classes = apply_filters( 'qoxag_html_class', $classes );

		$output .= ' class="'. join( ' ', array_filter( $classes ) ) .'" data-skin="'. $data_skin .'"';

		return $output;
	}
}

/**
 * Skin Switcher
 */
if( ! function_exists( 'qoxag_skin_switcher_head_js' ) ) {
	add_action( 'wp_head', 'qoxag_skin_switcher_head_js', 1 );
	function qoxag_skin_switcher_head_js(){
		if( qoxag_option('style_darklight_mode') == 'yes' ){		
		?>
		<script type="text/javascript">try{if("undefined"!=typeof localStorage){var digiSkin=localStorage.getItem("digi-skin"),html=document.getElementsByTagName("html")[0].classList,htmlSkin="light";if(html.contains("dark-mode")&&(htmlSkin="dark"),null!=digiSkin&&digiSkin!=htmlSkin){html.add("digi-skin-switch");var digiSkinInverted=!0}"dark"==digiSkin?html.add("dark-mode"):"light"==digiSkin&&html.remove("dark-mode")}}catch(t){console.log(t)}</script>
		<?php
		}
	}
}

if( ! function_exists( 'qoxag_review_rating' ) ) {
	function qoxag_review_rating($arg = []){
		if(function_exists('review_kit_rating')){
			echo review_kit_rating($arg); 
		}
	}
}
